% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flowgini.R
\name{flowgini}
\alias{flowgini}
\title{Analysis of flow concentration (Gini coefficient)}
\usage{
flowgini(ODpts, origin, destination, valflow, lorenz.plot)
}
\arguments{
\item{ODpts}{the input  dataset with : nodes code, flow values and XY coordinates}

\item{origin}{ID origin place, in long format}

\item{destination}{ID destination place, long format}

\item{valflow}{flow value between origin and destination places}

\item{lorenz.plot}{to plot or the Lorenz curve. See Details}
}
\value{
plot Lorenz curve for the cumulated flow and links : flowgini(...,gini.plot = TRUE),warning : the function must be not assign a variable

value of the Gini's coefficent and the table : table<-flowgini(...,missing(gini.plot) or gini.plot = FALSE )
}
\description{
Calculates Gini coefficient, plot Lorenz curve and
threshold the matrice according to a global concentration criterion
for mapping flow intensity or flow density.\cr
To be use before \link{flowanalysis}
}
\details{
flowgini(...,lorenz.plot = TRUE) for ploting Lorenz curve  associate to the gini coefficient, from cumulated flows and links.
}
\examples{
library(cartograflow)
data(flowdata)
# Computes Gini's coefficent
tabgini <- flowgini(ODpts = flows, origin = "i", destination = "j", 
                     valflow = "Fij", lorenz.plot = FALSE)
# Plot Lorenz curve
flowgini(ODpts = flows, origin = "i", dest = "j", valflow = "Fij", lorenz.plot = TRUE)
# See \link{flowanalysis} for viewing the tab_gini table
}
\references{
Bahoken Françoise, 2016,« La cartographie d’une sélection globale de flux, entre ‘significativité’ et ‘densité’ »,
Netcom Online, 30-3/4 | 2016, Online since 23 March 2017, connection on 05 May 2019. URL : http://journals.openedition.org/netcom/2565 ;
DOI : 10.4000/netcom.2565. \cr
Grasland Claude, 2014, "Flows analysis carto", unpublished R functions.
}
