% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bagEarth.R, R/bagFDA.R
\name{summary.bagEarth}
\alias{summary.bagEarth}
\alias{summary.bagFDA}
\alias{summary.bagFDA}
\title{Summarize a bagged earth or FDA fit}
\usage{
\method{summary}{bagEarth}(object, ...)

\method{summary}{bagFDA}(object, ...)
}
\arguments{
\item{object}{an object of class "bagEarth" or "bagFDA"}

\item{\dots}{optional arguments (not used)}
}
\value{
a list with elements \item{modelInfo}{a matrix with the number of
model terms and variables used} \item{oobStat }{a summary of the out-of-bag
statistics} \item{bmarsCall }{the original call to \code{bagEarth}}
}
\description{
The function shows a summary of the results from a bagged earth model
}
\details{
The out-of-bag statistics are summarized, as well as the distribution of the
number of model terms and number of variables used across all the bootstrap
samples.
}
\examples{

\dontrun{
data(trees)
set.seed(9655)
fit <- bagEarth(trees[,-3], trees[3])
summary(fit)
}

}
\author{
Max Kuhn
}
\keyword{manip}
