% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sort_ard_hierarchical.R
\name{sort_ard_hierarchical}
\alias{sort_ard_hierarchical}
\title{Sort Stacked Hierarchical ARDs}
\usage{
sort_ard_hierarchical(x, sort = everything() ~ "descending")
}
\arguments{
\item{x}{(\code{card})\cr
a stacked hierarchical ARD of class \code{'card'} created using \code{\link[=ard_stack_hierarchical]{ard_stack_hierarchical()}} or
\code{\link[=ard_stack_hierarchical_count]{ard_stack_hierarchical_count()}}.}

\item{sort}{(\code{\link[=syntax]{formula-list-selector}}, \code{string})\cr
a named list, a list of formulas, a single formula where the list element is a named list of functions
(or the RHS of a formula), or a single string specifying the types of sorting to perform at each hierarchy variable
level. If the sort method for any variable is not specified then the method will default to \code{"descending"}. If a
single unnamed string is supplied it is applied to all variables. For each variable, the value specified must
be one of:
\itemize{
\item \code{"alphanumeric"} - at the specified hierarchy level of the ARD, groups are ordered alphanumerically
(i.e. A to Z) by \code{variable_level} text.
\item \code{"descending"} - within each variable group of the ARD at the specified hierarchy level, count sums are
calculated for each group and groups are sorted in descending order by sum. When \code{sort} is \code{"descending"} for a
given variable and \code{n} is included in \code{statistic} for the variable then \code{n} is used to calculate variable group
sums, otherwise \code{p} is used. If neither \code{n} nor \code{p} are present in \code{x} for the variable, an error will occur.
}

Defaults to \code{everything() ~ "descending"}.}
}
\value{
an ARD data frame of class 'card'
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}\cr

This function is used to sort stacked hierarchical ARDs.

For the purposes of this function, we define a "variable group" as a combination of ARD rows grouped by the
combination of all their variable levels, but excluding any \code{by} variables.
}
\note{
If overall data is present in \code{x} (i.e. the ARD was created with \code{ard_stack_hierarchical(overall=TRUE)}), the
overall data will be sorted last within each variable group (i.e. after any other rows with the same combination of
variable levels).
}
\examples{
\dontshow{if ((identical(Sys.getenv("NOT_CRAN"), "true") || identical(Sys.getenv("IN_PKGDOWN"), "true"))) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
ard_stack_hierarchical(
  ADAE,
  variables = c(AESOC, AEDECOD),
  by = TRTA,
  denominator = ADSL,
  id = USUBJID
) |>
  sort_ard_hierarchical(AESOC ~ "alphanumeric")

ard_stack_hierarchical_count(
  ADAE,
  variables = c(AESOC, AEDECOD),
  by = TRTA,
  denominator = ADSL
) |>
  sort_ard_hierarchical(sort = list(AESOC ~ "alphanumeric", AEDECOD ~ "descending"))
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=filter_ard_hierarchical]{filter_ard_hierarchical()}}
}
