% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ard_stack.R
\name{ard_stack}
\alias{ard_stack}
\title{Stack ARDs}
\usage{
ard_stack(
  data,
  by = NULL,
  ...,
  .overall = FALSE,
  .missing = FALSE,
  .attributes = FALSE,
  .shuffle = FALSE
)
}
\arguments{
\item{data}{(\code{data.frame})\cr
a data frame}

\item{by}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
columns to tabulate by in the series of ARD function calls}

\item{...}{(\code{\link[=dyn-dots]{dynamic-dots}})\cr
Series of ARD function calls to be run and stacked}

\item{.overall}{(\code{logical})\cr logical indicating whether overall statistics
should be calculated (i.e. re-run all \verb{ard_*()} calls with \code{by=NULL}).
Default is \code{FALSE}.}

\item{.missing}{(\code{logical})\cr
logical indicating whether to include the results of \code{ard_missing()} for all
variables represented in the ARD. Default is \code{FALSE}.}

\item{.attributes}{(\code{logical})\cr
logical indicating whether to include the results of \code{ard_attributes()} for all
variables represented in the ARD. Default is \code{FALSE}.}

\item{.shuffle}{(\code{logical})\cr
logical indicating whether to perform \code{shuffle_ard()} on the final result.
Default is \code{FALSE}.}
}
\value{
a transformed ARD data frame (of class 'card' if \code{.shuffle = FALSE})
}
\description{
Stack multiple ARD calls sharing common input \code{data} and \code{by} variables.
Optionally incorporate additional information on represented variables (i.e.
big N's, missingness, attributes) and/or tidy for use in displays with
\code{shuffle_ard()}.
}
\examples{
ard_stack(
  data = ADSL,
  by = "ARM",
  ard_categorical(variables = "AGEGR1"),
  ard_continuous(variables = "AGE")
)

ard_stack(
  data = ADSL,
  by = "ARM",
  ard_categorical(variables = "AGEGR1"),
  ard_continuous(variables = "AGE"),
  .shuffle = TRUE
)

}
