% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/branching.R
\name{gen_curvybranches}
\alias{gen_curvybranches}
\title{Generate data with curvy shaped branches}
\usage{
gen_curvybranches(n = 400, p = 4, k = 4, noise_fun = gen_noisedims, ...)
}
\arguments{
\item{n}{A numeric value (default: 400) representing the sample size.}

\item{p}{A numeric value (default: 4) representing the number of dimensions.}

\item{k}{A numeric value (default: 4) representing the number of branches.}

\item{noise_fun}{A function specifying which noise generation function to
use for the additional dimensions. Default is \code{gen_noisedims}.
Other options include \code{gen_wavydims1}, \code{gen_wavydims2}, and \code{gen_wavydims3}.}

\item{...}{Additional arguments passed to the selected \code{noise_fun}
(e.g., \code{m}, \code{s}, \code{theta}, \code{x1_vec}, \code{data}).}
}
\value{
A data containing non-linear shaped branches.
}
\description{
This function generates a dataset representing a structure with non-linear shaped branches.
}
\examples{
set.seed(20240412)
curvybranches <- gen_curvybranches(n = 400, p = 4, k = 4,
noise_fun = gen_noisedims, m = rep(0, 2), s = rep(0.05, 2))
}
