% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vehicle_emissions.R
\name{vehicle_emissions}
\alias{vehicle_emissions}
\title{Calculate CO2e emissions from land-travel journeys}
\usage{
vehicle_emissions(
  distance,
  units = c("miles", "km"),
  num = 1,
  vehicle = c("Cars", "Motorbike"),
  fuel = c("Petrol", "Diesel", "Unknown", "Battery Electric Vehicle",
    "Plug-in Hybrid Electric Vehicle"),
  car_type = c("Average car", "Small car", "Medium car", "Large car", "Mini",
    "Supermini", "Lower medium", "Upper medium", "Executive", "Luxury", "Sports",
    "Dual purpose 4X4", "MPV"),
  bike_type = c("Average", "Small", "Medium", "Large"),
  TD = TRUE,
  include_WTT = TRUE,
  include_electricity = TRUE,
  owned_by_org = TRUE
)
}
\arguments{
\item{distance}{Distance in km or miles of the journey made (this can be calculated with other tools, such as google maps.).}

\item{units}{Units for the distance travelled. Options are \code{"km"} or \code{"miles"}.}

\item{num}{Number of vehicles used.}

\item{vehicle}{Vehicle used for the journey. Options are \code{"Cars"}, \code{"Motorbike"}.}

\item{fuel}{Fuel type used for the journey. For car, \code{"Petrol"}, \code{"Diesel"}, \code{"Unknown"}, \code{"Battery Electric Vehicle"}, \code{"Plug-in Hybrid Electric Vehicle"} are options. ##' \code{"hybrid electric"} and \code{"battery electric"} account for electricity kWh emissions.}

\item{car_type}{Size/type of vehicle for car.
Options are \verb{c("Average car", "Small car", "Medium car", "Large car",}
\verb{"Mini", "Supermini", "Lower medium", "Upper medium", "Executive",}
\verb{"Luxury", "Sports", "Dual purpose 4X4", "MPV"),}.
Small denotes up to a 1.4L engine, unless diesel which is up to 1.7L engine. Medium denotes 1.4-2.0L for petrol cars, 1.7-2.0L for diesel cars. Large denotes 2.0L+ engine.}

\item{bike_type}{Size of vehicle for motorbike.
Options are \code{"Small"}, \code{"Medium"}, \code{"Large"}, or \code{"Average"}.
Sizes denote upto 125cc, 125cc-500cc, 500cc+ respectively.}

\item{TD}{logical.Whether to account for transmission and distribution (TD) for electric vehicles  (only \code{car} and \code{van})}

\item{include_WTT}{logical. Well-to-tank (include_WTT) - whether to account for emissions associated with extraction, refining and transportation of the fuels (for non-electric vehicles).}

\item{include_electricity}{logical. Whether to account for ... for electric vehicles (car and van).}

\item{owned_by_org}{logical. Whether the vehicle used is owned by the organisation or not (only for \code{car}, \code{motorbike}).}
}
\value{
Tonnes of CO2e emissions per mile travelled.
}
\description{
A function that calculates CO2e emissions on a journey on land.
}
\examples{
# Emissions for a 100 mile car journey
 vehicle_emissions(distance = 100)

# Emissions for a 100 mile motorbike journey where the motorbike is 500+cc
 vehicle_emissions(distance = 100, vehicle = "Motorbike", bike_type = "Large")
}
