% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lin_alg_advanced.R
\name{kronecker,caracas_symbol,caracas_symbol-method}
\alias{kronecker,caracas_symbol,caracas_symbol-method}
\title{Kronecker product of two matrices}
\usage{
\S4method{kronecker}{caracas_symbol,caracas_symbol}(X, Y, FUN = "*", make.dimnames = FALSE, ...)
}
\arguments{
\item{X, Y}{matrices as caracas symbols.}

\item{FUN}{a function; it may be a quoted string.}

\item{make.dimnames}{Provide dimnames that are the product of the dimnames of
‘X’ and ‘Y’.}

\item{...}{optional arguments to be passed to ‘FUN’.}
}
\value{
Kronecker product of A and B.
}
\description{
Computes the Kronecker product of two matrices.
}
\examples{
if (has_sympy()) {
  A <- matrix_sym(2, 2, "a")
  B <- matrix_sym(2, 2, "b")
  II <- matrix_sym_diag(2)
  EE <- eye_sym(2,2)
  JJ <- ones_sym(2,2)

  kronecker(A, B)
  kronecker(A, B, FUN = "+")
  kronecker(II, B)
  kronecker(EE, B)
  kronecker(JJ, B)
}

}
\concept{linalg}
