% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculus.R
\name{intf}
\alias{intf}
\title{Integrate a function}
\usage{
intf(f, var, lower, upper, doit = TRUE)
}
\arguments{
\item{f}{Function to integrate}

\item{var}{Variable to integrate with respect to (either string or \code{caracas_symbol})}

\item{lower}{Lower limit}

\item{upper}{Upper limit}

\item{doit}{Evaluate the integral immediately (or later with \code{\link[=doit]{doit()}})}
}
\description{
If no limits are provided, the
indefinite integral is calculated.
Otherwise, if both limits are provided,
the definite integral is calculated.
}
\examples{
if (have_sympy()) {
  x <- symbol("x")
  
  intf(1/x, x, 1, 10)
  intf(1/x, x, 1, 10, doit = FALSE)
  intf(1/x, x)
  intf(1/x, x, doit = FALSE)
}

}
\concept{calculus}
