% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_stats_multiallele.R
\name{get_stats_multiallele}
\alias{get_stats_multiallele}
\title{Perform linear regression on multi-allele markers.}
\usage{
get_stats_multiallele(phenotype, genotype, covar_table, ph_family, ref_col)
}
\arguments{
\item{phenotype}{A phenotype vector}

\item{genotype}{genotypes of the marker being tested. 
If this is a vector, it will be converted into a one-column 
matrix. If it is a matrix, each column represents an allele,
and each row represents an individual.}

\item{covar_table}{The covariate matrix, with each covariate
in a column, and each individual in a row.}

\item{ph_family}{a character string for a description of the 
error distribution. Can be either "gaussian" or "binomial"}

\item{ref_col}{The column belonging to the reference allele.
The reference allele is removed from the genotype matrix so
that the matrix is linearly independent. There are only n-1
degrees of freedom in the genotype matrix, where n is the number
of alleles.}
}
\value{
a list with "stats", "pval", "score"
stats is a matrix holding the t statistics and slopes (beta coefficients)
from the linear model.
pval holds the p value for the marker overall
and score holds the test statistic for the marker overall.
}
\description{
This function performs the multi-allele version of 
linear regression. It is used in \code{\link{singlescan}}
and \code{\link{one_singlescanDO}}. It performs marker-by-marker
linear regressions for each trait and adjusts for covariates.
It collects parameters from the linear models and returns
for downstream use.
}
\keyword{internal}
