% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/canvasXpress.R
\name{canvasXpress}
\alias{canvasXpress}
\title{HTML Widget Creation}
\usage{
canvasXpress(
  data = NULL,
  smpAnnot = NULL,
  varAnnot = NULL,
  graphType = "Scatter2D",
  events = NULL,
  afterRender = NULL,
  pretty = FALSE,
  digits = 4,
  width = 600,
  height = 400,
  destroy = FALSE,
  ...
)
}
\arguments{
\item{data}{data.frame-, matrix-, list- , or ggplot- classed object}

\item{smpAnnot}{additional data that applies to samples (columns)}

\item{varAnnot}{additional data that applies to variables (rows)}

\item{graphType}{type of graph to be plotted - default = "Scatter2D"}

\item{events}{user-defined events (e.g. mousemove, mouseout, click and dblclick)}

\item{afterRender}{event triggered after rendering}

\item{pretty}{print tagged code (JSON/HTML) nicely - default = FALSE}

\item{digits}{display digits - default = 4}

\item{width}{plot width (valid CSS units) - default = 600px}

\item{height}{plot height (valid CSS units) - default = 400px}

\item{destroy}{used to indicate removal of a plot - default = FALSE}

\item{...}{additional parameters passed to canvasXpress}
}
\value{
htmlwidgets object
}
\description{
Custom HTML widget creation function based on widget YAML and JavaScript for
use in any html-compatible context
}
\section{Piping Support}{

  Piping is supported (both the magrittr '%>%' and native '|>' pipes) when sending an existing
  canvasXpress object into data parameter.  Any new parameters will be added to the original configuration
  of the object, any parameters with data that existed before will be replaced, and any parameters set
  to null will be removed.  It is important to note that primary data changes are not allowed in this
  construct - which means that anything specified by using the data, varAnnot, or smpAnnot parameters
  cannot be changed from the original values.
}

