% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/html_functionality.R
\name{cxHtmlPage}
\alias{cxHtmlPage}
\title{Stand-Alone HTML Page Creation}
\usage{
cxHtmlPage(chartObject, width = NULL, height = NULL)
}
\arguments{
\item{chartObject}{a canvasXpress plot object}

\item{width}{plot width override for the HTML page (valid CSS units)  - default = NULL}

\item{height}{plot height override for the HTML page (valid CSS units) - default = NULL}
}
\value{
a character string containing a self-contained html page
}
\description{
This function creates and returns a stand-alone HTML page containing
the given canvasXpress object.  Width and height can be inferred from
the canvasXpress object (default) or overridden for the page output.
}
\examples{
my_chart <- canvasXpress(data      = data.frame(Sample1 = c(33, 48),
                                                Sample2 = c(44, 59),
                                                Sample3 = c(55, 6)),
                         graphType = "Bar",
                         title     = "Example Bar Chart",
                         width     = "600px")

# create a page using the chart dimensions on my_chart
html_page <- cxHtmlPage(my_chart)

# or change the chart width/height for this page:
html_page <- cxHtmlPage(my_chart, width = "100\%", height = "70vh")

# save page for viewing/sharing
writeLines(html_page, tempfile(fileext = ".html"))

}
