% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_organisation_units_metadata.R
\name{get_organisation_units_metadata}
\alias{get_organisation_units_metadata}
\title{Get Organisation Units Metadata}
\usage{
get_organisation_units_metadata(
  org_ids = NULL,
  level = c("country", "county", "subcounty", "ward", "facility")
)
}
\arguments{
\item{org_ids}{The organisation identifiers whose details being retrieved}

\item{level}{The desired data granularity: \code{"country"} (the default), \code{"county"}, \code{"subcounty"}, \code{"ward"}, or \code{"facility"}.}
}
\value{
A tibble containing the following columns:
\itemize{
\item id            - Organisation identifier that uniquely identifies the organisation by level
\item country       - Name of the country
\item county        - Name of the county.
\item subcounty     - Name of the subcounty.
\item ward          - Name of the ward.
\item facility      - Name of the health facility.
}
}
\description{
\code{get_organisation_units_metadata()} fetches organisation units metadata from the
KHIS API server.
}
\examples{
\dontshow{if (khis_has_cred()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Fetch all the organisation units metadata
organisations <- get_organisation_units_metadata()
organisations
\dontshow{\}) # examplesIf}
}
