% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cancerscreening-package.R, R/utils-ui.R
\name{cancerscreening-configuration}
\alias{cancerscreening-configuration}
\alias{with_cancerscreening_quiet}
\alias{local_cancerscreening_quiet}
\title{cancerscreening configuration}
\usage{
with_cancerscreening_quiet(code)

local_cancerscreening_quiet(env = parent.frame())
}
\arguments{
\item{code}{Code to execute quietly}

\item{env}{The environment to use for scoping}
}
\value{
No return value, called for side effects

No return value, called for side effects

No return value, called for side effects
}
\description{
Some aspects of cancerscreening behaviour can be controlled via an option.
}
\section{Messages}{


The \code{cancerscreening_quiet} option can be used to suppress messages form
cancerscreening. By default, cancerscreening always messages, i.e. it is \emph{not}
quiet.

set \code{cancerscreening_quiet} to \code{TRUE} to suppress message, by one of these
means, in order of decreasing scope:
\itemize{
\item Put \code{options(cancerscreening_quiet = TRUE)} in the start-up file, such as
\code{.Rprofile}, or  in your R script
\item Use \code{local_cancerscreening_quiet()} to silence cancerscreening in a specific
scope
\item Use \code{with_cancerscreening_quite} to run small bit of code silently
}

\code{local_cancerscreening_quiet} and \code{with_cancerscreening} follow the conventions
of the withr package (\url{https://withr.r-lib.org}).
}

\examples{
# message: "The credentials have been set."
khis_cred(username = 'username', password = 'password')

# suppress messages for a small amount of code
with_cancerscreening_quiet(
  khis_cred(username = 'username', password = 'password')
)
# message: "The credentials have been set."
khis_cred(username = 'username', password = 'password')

# suppress messages for a in a specific scope
local_cancerscreening_quiet()

# no message
khis_cred(username = 'username', password = 'password')

# clear credentials
khis_cred_clear()
}
