% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/events.R
\name{events}
\alias{events}
\title{Get events}
\usage{
events(x)
}
\arguments{
\item{x}{Camera Trap Data Package object, as returned by
\code{read_camtrapdp()}.}
}
\value{
\code{\link[=tibble]{tibble()}} data frame with the events, containing the following
columns:
\itemize{
\item \code{deploymentID}
\item \code{eventID}
\item \code{eventStart}
\item \code{eventEnd}
}
}
\description{
Gets the (unique) events from the observations of a Camera Trap Data
Package object.
Only observations with \code{observationLevel == "event"} are considered.
}
\examples{
x <- example_dataset()
events(x)
}
\seealso{
Other accessor functions: 
\code{\link{deployments}()},
\code{\link{locations}()},
\code{\link{media}()},
\code{\link{observations}()},
\code{\link{taxa}()}
}
\concept{accessor functions}
