% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rx-break.R
\name{rx_break}
\alias{rx_break}
\title{Form a word break regex pattern}
\usage{
rx_break(pattern)
}
\arguments{
\item{pattern}{A regex pattern (a word) to wrap in \verb{\\\\b}.}
}
\value{
The a glue vector of \code{pattern} wrapped in \verb{\\\\b}.
}
\description{
Wrap a word in word boundary (\verb{\\\\b}) characters. Useful when combined with
\code{\link[stringr:str_subset]{stringr::str_which()}} and \code{\link[stringr:str_detect]{stringr::str_detect()}} to match only entire words
and not that word \emph{inside} another word (e.g., "sting" and "testing").
}
\examples{
rx_break("test")
rx_break(state.abb[1:5])
}
