% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/align.R
\name{align}
\alias{align}
\title{align}
\usage{
align(
  chunk_size = 15,
  step_size = 0.5,
  all_files = NULL,
  path_recordings = NULL,
  path_chunks = NULL,
  chunk_seq = NULL,
  keys_id = NULL,
  keys_rec = NULL,
  blank = 15,
  wing = 10,
  ffilter_from = NULL,
  down_sample = NULL,
  save_pdf = FALSE,
  save_log = FALSE,
  quiet = FALSE
)
}
\arguments{
\item{chunk_size}{numeric, duration in minutes of the chunks to output. Default is `15`.}

\item{step_size}{numeric, duration in seconds of the bins for signal compression before cross correlation.
Default is `0.5`.}

\item{all_files}{character vector, paths to all raw recordings to consider. If `NULL` files are listed
based on the argument `path_recordings`.}

\item{path_recordings}{character, the path where the raw recordings are stored. Can be nested in folders,
in this case provide the top-level folder.}

\item{path_chunks}{character, the path where aligned chunks should be stored.}

\item{chunk_seq}{numeric vector or `NULL`. If supplied only these chunks are rerun.}

\item{keys_id}{character vector of length 2. The characters before and after the unique ID of the
individual or microphone. This can be in the file name or in the folder structure. E.g., if the path to the
recording is `../data/week_1/recording_mic1.wav` the keys would be `c('recording_', '.wav')` and the
function would retrieve `mic1` as individual id.}

\item{keys_rec}{character vector of length 2. The characters before and after the unique ID of the
recording. This can be in the file name or in the folder structure. E.g., if the path to the recording
is `../data/week_1/recording_mic1.wav` the keys would be `c('data/', '/recording')` and the function would
retrieve `week_1` as recording id.}

\item{blank}{numeric, the duration in minutes to be discarded at the beginning and end of the recording.}

\item{wing}{numeric, the duration in minutes to load before and after each chunk to improve alignment. This
is not saved with the aligned chunk.}

\item{ffilter_from}{numeric, frequency in Hz for the high-pass filter.}

\item{down_sample}{numeric, the sample rate for down-sampling. If `NULL` no down-sampling is done.}

\item{save_pdf}{logical, if `TRUE` a pdf is saved with a page per chunk that shows all the aligned
recordings.}

\item{save_log}{logical, if `TRUE` a csv file with all alignment times is saved in path_chunks.}

\item{quiet}{logical, if `TRUE` no messages are printed.}
}
\value{
saves all the aligned chunks in the location specific by `path_chunks`.
}
\description{
Aligns multiple recordings (.wav files). It assumes all microphones are within recording range
of each other most of the time.
}
\details{
There are two ways to tell the function where the files are. You can either compile a character
vector of pathnames yourself and enter this under `all_files` or you can give a single character path to
`path_recordings`. You need to make sure that there is an identifier by which to group the recordings and
an identifier for each individual or microphone in the path. This can either be a in the folder structure
or in the file names themselves. The align function will align all individuals per recording id (e.g.,
date). These identifiers are found using regexp, so mostly you can use the first few characters before
and after them (see examples in the argument descriptions). The function loads chunks of the recordings,
sums the absolute amplitude per bin and runs cross correlation to find alignment relative to the first
recording. The aligned chunks are then saved.
}
