% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detect.and.assign.R
\name{detect.and.assign}
\alias{detect.and.assign}
\title{detect.and.assign}
\usage{
detect.and.assign(
  all_files = NULL,
  path_chunks = NULL,
  path_calls = NULL,
  ffilter_from = 1100,
  threshold = 0.4,
  msmooth = c(1000, 95),
  min_dur = 0.1,
  max_dur = 0.3,
  step_size = 0.01,
  wing = 6,
  save_files = TRUE,
  quiet = FALSE,
  save_extra = 0
)
}
\arguments{
\item{all_files}{character vector or `NULL`. Character vector should contain all the paths to the raw
recordings that should be considered. If `NULL` files are loaded from `path_chunks`.}

\item{path_chunks}{character, path to where the chunks are stored.}

\item{path_calls}{character, path to where to store the results.}

\item{ffilter_from}{numeric, frequency in Hz for the high-pass filter.}

\item{threshold}{numeric, threshold (fraction of the maximum) for amplitude envelope when detecting call.}

\item{msmooth}{used as argument for the `seewave::env` function. *A vector of length 2 to smooth the
amplitude envelope with a mean sliding window. The first component is the window length (in number of
points). The second component is the overlap between successive windows (in \%).* Default is `c(500, 95)`.}

\item{min_dur}{numeric, the minimal duration in seconds for a detection to be saved. Default is `0.1`.}

\item{max_dur}{numeric, the maximal duration in seconds for a detection to be saved. Default is `0.3`.}

\item{step_size}{numeric, duration in seconds of the bins for signal compression before cross correlation.
Default is `0.01`.}

\item{wing}{numeric, the duration in minutes to load before and after each chunk to improve alignment. This
is not saved with the aligned chunk.}

\item{save_files}{logical, if `TRUE` the files are stored in the `path_chunks` location. Results are also
returned.}

\item{quiet}{logical, if `TRUE` no messages are printed.}

\item{save_extra}{numberic, how much to add to start and end time in seconds. Can be used to make sure
the whole vocalisation is included.}
}
\value{
Returns a data frame with start = start time in samples and end = end time in samples for each
detection.
}
\description{
Traces the fundamental frequency from a wave object. Also applies smoothening to trace.
}
