% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/presets.R
\name{r_safe}
\alias{r_safe}
\title{Run an R child process in safe mode}
\usage{
r_safe(func, args = list(), libpath = .libPaths(),
  repos = c(getOption("repos"), c(CRAN = "https://cran.rstudio.com")),
  cmdargs = c("--no-site-file", "--no-environ", "--slave", "--no-save",
  "--no-restore"), system_profile = FALSE, user_profile = FALSE,
  env = c(CYGWIN = "nodosfilewarning", R_TESTS = "", R_BROWSER = "false",
  R_PDFVIEWER = "false"), ...)
}
\arguments{
\item{func}{Function object to call in the new R process.
The function should be self-contained and only refer to
other functions and use variables explicitly from other packages
using the \code{::} notation. The environment of the function
is set to \code{.GlobalEnv} before passing it to the child process.
Because of this, it is good practice to create an anonymous
function and pass that to \code{callr}, instead of passing
a function object from a (base or other) package. In particular
\preformatted{  r(.libPaths)} does not work, because it is
defined in a special environment, but
\preformatted{  r(function() .libPaths())} works just fine.}

\item{args}{Arguments to pass to the function. Must be a list.
vector.}

\item{libpath}{The library path.}

\item{repos}{The \sQuote{repos} option. If \code{NULL}, then no
\code{repos} option is set. This options is only used if
\code{user_profile} or \code{system_profile} is set to \code{FALSE},
as it is set using the system or the user profile.}

\item{cmdargs}{Command line arguments to pass to the R process.
Note that \code{c("-f", rscript)} is appended to this, \code{rscript}
is the name of the script file to run. This contains a call to the
supplied function and some error handling code.}

\item{system_profile}{Whether to use the system profile file.}

\item{user_profile}{Whether to use the user's profile file.}

\item{env}{Environment variables to set for the child process.}

\item{...}{Additional arguments are passed to \code{\link{r}}.}
}
\description{
The following options are set up: \itemize{
  \item The library path is set to the current path.
  \item Makes sure that at least one reasonable CRAN mirror is set up.
  \item Some command line arguments are added to avoid saving
    \code{.RData} files, etc. See them above.
  \item The system and user profile files are ignored.
  \item Various environment variables are set: \code{CYGWIN} to avoid
    warnings about DOS-style paths, \code{R_TESTS} to avoid issues
    when \code{callr} is invoked from unit tests, \code{R_BROWSER}
    and \code{R_PDFVIEWER} to avoid starting a browser or a PDF viewer.
}
}
\seealso{
Other callr functions: \code{\link{r_vanilla}},
  \code{\link{r}}
}

