% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conversions.R
\name{getCT}
\alias{getCT}
\title{Converting a data matrix into a contingency table}
\usage{
getCT(
  Xinput,
  input = "nbyp",
  Jk = NULL,
  maxcat = NULL,
  varandcat = TRUE,
  vars = NULL
)
}
\arguments{
\item{Xinput}{A data matrix, in the form of a data frame or similar}

\item{input}{See \code{\link{getBurt}}}

\item{Jk}{See \code{\link{convert}}}

\item{maxcat}{See \code{\link{convert}}}

\item{varandcat}{See \code{\link{convert}}}

\item{vars}{A list of the variable numbers to be used in the contingency table when there are more than 2. \cr
If not all variables are wanted and the input is not n by p then Jk must be specified.}
}
\value{
A contingency table, giving counts for the two cross-classified variables
}
\description{
\code{getCT} recodes a data matrix from one format (n objects by p variables,
counts for distinct combinations of p variables, indicator matrix or Burt matrix) into a contingency table,
for cases where table() doesn't work
}
\examples{
nishCTvars23 <- getCT(NishData,Jk=rep(3,4),vars=2:3)

}
\seealso{
Other conversion functions: 
\code{\link{convert}()},
\code{\link{getBurt}()},
\code{\link{getdoubled}()},
\code{\link{getindicator}()}
}
\concept{conversion functions}
