% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conversions.R
\name{getBurt}
\alias{getBurt}
\title{Converting a data matrix into a Burt matrix}
\usage{
getBurt(
  Xinput,
  input = "nbyp",
  Jk = NULL,
  maxcat = NULL,
  varandcat = TRUE,
  vars = NULL
)
}
\arguments{
\item{Xinput}{A data matrix, in the form of a data frame or similar}

\item{input}{The format of the input matrix:
\describe{
  \item{"nbyp"}{An n individuals/objects/data points by p categorical variables matrix,
  where each row is a different data point and each column contains the category
  for that data point on that variable, where these categories can be numbers, strings or factors}
  \item{"nbypcounts"}{Similar to the above, but each row represents all of the data points taking
  the same combination of categories, and the first column contains the count for this combination
  (hence the name used here is a bit of a misnomer, but it emphasises the similarities to an n by p)}
  \item{"indicator"}{An indicator matrix, similar to the n by p matrix except that a variable with J_k categories
  is represented by J_k columns and a data point taking the i-th category has 1 in the i-th
  of these columns and a zero in the others}
  \item{"Burt"}{A Burt matrix, symmetrical and block-diagonal with each block being a
  contingency table for a pair of variables}
 }}

\item{Jk}{See \code{\link{convert}}}

\item{maxcat}{See \code{\link{convert}}}

\item{varandcat}{See \code{\link{convert}}}

\item{vars}{A list of the variable numbers to be used in the Burt matrix, if only a subset is wanted.\cr
If not all variables are wanted and the input is not n by p then Jk must be specified.}
}
\value{
A Burt matrix, symmetrical and block-diagonal with each block being a contingency table for a pair of variables
}
\description{
\code{getBurt} recodes a data matrix from one format (n objects by p variables,
counts for distinct combinations of p variables, contingency table) into a Burt matrix,
or extracts a subset of a Burt matrix for selected variables
}
\examples{
nishburt <- getBurt(NishData)
nishburtvars1to3 <- getBurt(NishData,vars=1:3)
nishburtvars2and4 <- getBurt(nishburt,input="Burt",Jk=rep(3,4),vars=c(2,4))

}
\seealso{
Other conversion functions: 
\code{\link{convert}()},
\code{\link{getCT}()},
\code{\link{getdoubled}()},
\code{\link{getindicator}()}
}
\concept{conversion functions}
