% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/computerized_adaptive_test_function.R
\name{computerized_adaptive_test}
\alias{computerized_adaptive_test}
\title{Computerized Adaptive Test}
\usage{
computerized_adaptive_test(
  cat_item_bank,
  response_matrix,
  initial_theta = 0,
  model = NULL,
  randomesque = 1,
  maxItems = 50,
  method = "BM",
  nextItemControl = list(criterion = "MFI", method = method, priorDist = "norm",
    priorPar = c(0, 1), D = 1, range = c(-4, 4), parInt = c(-4, 4, 33), infoType =
    "Fisher", random.seed = NULL, rule = "precision", thr = 0.3, SETH = NULL, AP = 1,
    nAvailable = NULL, cbControl = NULL, cbGroup = NULL),
  ...
)
}
\arguments{
\item{cat_item_bank}{A data frame with the items on the rows and their item parameters on the columns. These should be in the \pkg{catR} package format for item banks.}

\item{response_matrix}{A matrix of the person responses, with individuals as rows and items as columns.}

\item{initial_theta}{The initial theta estimate for all individuals. Default is 0.}

\item{model}{Either NULL (default) for dichotomous models or a character value indicating the polytomous model used. See the \pkg{mstR} package for more details.}

\item{randomesque}{An integer value that indicates the number of items from which the selection rule should choose from randomly for administration. See the help documentation for \code{catR::nextItem} for more details.}

\item{maxItems}{An integer value indicating the maximum number of items to administer, regardless of other stopping rules.}

\item{method}{A character value indicating method for the provisional theta estimate. Defaults to "BM" (Bayes Modal). See the \pkg{catR} package for more details.}

\item{nextItemControl}{A list of control values passed to \code{catR::nextItem}. See that function for more details.}

\item{...}{Further arguments to be passed to internal functions. Currently unimplemented.}
}
\value{
An S4 object of class 'CAT' with the following slots:
\item{function.call}{The function and arguments called to create this object.}
\item{final.theta.estimate}{A numeric vector of the final theta estimates using the \code{method} provided in \code{function.call}.}
\item{eap.theta}{A numeric vector of the final theta estimates using the expected a posteriori (EAP) theta estimate from \code{catR::eapEst}.}
\item{final.theta.Baker}{A numeric vector of the final theta estimates using an iterative maximum likelihood estimation procedure as described in chapter 5 of Baker (2001).}
\item{final.theta.SEM}{A numeric vector of the final standard error of measurement (SEM) estimates using an iterative maximum likelihood estimation procedure as described in chapter 5 of Baker (2001)[http://echo.edres.org:8080/irt/baker/final.pdf].}
\item{final.items.seen}{A matrix of the final items seen by each individual using the supplied item names. \code{NA} values indicate that an individual wasn't given any items to answer after the last specified item in their row.}
\item{final.responses}{A matrix of the responses to the items seen in \code{final.items.seen}. \code{NA} values indicate that the individual didn't answer the question in the supplied response file or wasn't given any more items to answer.}
\item{runtime}{A \code{difftime} object recording how long the function took to complete.}
}
\description{
Computerized Adaptive Test
}
\examples{
data(example_thetas) # 5 simulated abilities
data(example_responses) # 5 simulated responses
data(cat_items) # using just the CAT routing stage items
catResults <- computerized_adaptive_test(cat_item_bank = cat_items,
response_matrix = example_responses, randomesque = 1, maxItems = 3,
nextItemControl = list(criterion = "MFI",
priorDist = "norm", priorPar = c(0, 1), D = 1, range = c(-4, 4),
parInt = c(-4, 4, 33), infoType = "Fisher", randomesque = 1, random.seed = NULL,
rule = "precision", thr = .3, nAvailable = NULL,
cbControl = NULL, cbGroup = NULL))
}
\references{
Baker, F. B. (2001). The basics of item response theory. For full text: http://echo.edres.org:8080/irt/baker/final.pdf.
}
\seealso{
[mixed_adaptive_test] for a multistage test with a routing module using item-level adaptation.
}
