% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/betaBinomial.R
\name{plot.cnormBetaBinomial}
\alias{plot.cnormBetaBinomial}
\title{Plot cnormBetaBinomial Model with Data and Percentile Lines}
\usage{
\method{plot}{cnormBetaBinomial}(x, ...)
}
\arguments{
\item{x}{A fitted model object of class "cnormBetaBinomial" or "cnormBetaBinomial2".}

\item{...}{Additional arguments passed to the plot method.
\itemize{
   \item age A vector the age data.
   \item A vector of the score data.
   \item weights An optional numeric vector of weights for each observation.
   \item percentiles An optional vector with the percentiles to plot.
   \item points Logical indicating whether to plot the data points. Default is TRUE.
 }}
}
\value{
A ggplot object.
}
\description{
This function creates a visualization of a fitted cnormBetaBinomial model,
including the original data points manifest percentiles and specified percentile lines.
}
\examples{

\dontrun{
# Computing beta binomial models already displays plot
model.bb <- cnorm.betabinomial(elfe$group, elfe$raw)

# Without data points
plot(model.bb, age = elfe$group, score = elfe$raw, weights=NULL, points=FALSE)

}
}
\seealso{
Other plot: 
\code{\link{plot.cnorm}()},
\code{\link{plot.cnormBetaBinomial2}()},
\code{\link{plotDensity}()},
\code{\link{plotDerivative}()},
\code{\link{plotNorm}()},
\code{\link{plotNormCurves}()},
\code{\link{plotPercentileSeries}()},
\code{\link{plotPercentiles}()},
\code{\link{plotRaw}()},
\code{\link{plotSubset}()}
}
\concept{plot}
