% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boxcox.R
\name{plotBoxCox}
\alias{plotBoxCox}
\title{Plot regression model versus box cox for a specific age}
\usage{
plotBoxCox(
  regressionModel,
  boxcoxParameters,
  minRaw = NULL,
  maxRaw = NULL,
  type = 0
)
}
\arguments{
\item{regressionModel}{The regression model from the 'bestModel' function}

\item{boxcoxParameters}{The parameters from the box cox power transformation}

\item{minRaw}{The lower bound of raw scores; must not fall below 0 due to restrictions of the
box cox function}

\item{maxRaw}{The upper bound of raw scores}

\item{type}{Type of plot; 0 = Show percentiles as function of raw scores, 1 = Show raw scores
as function of norm scores, 2 = Density plot}
}
\value{
data frame with fitted box cox and regression scores
}
\description{
This plot can be used to compare, how well the regression data can be modeled via a
Box Cox power transformation.
}
\examples{

# Calculate model based on PPVT4 data
data <- prepareData(ppvt)
model <- bestModel(data)

# compute power function for a specific age, e. g. 9.2
bc <- boxcox(model, 9.2)

# plot results as a function of norm scores
plotBoxCox(model, bc, minRaw=0, maxRaw=228, type=1)

# plot density
plotBoxCox(model, bc, minRaw=0, maxRaw=228, type=2)
}
\seealso{
boxcox
}
