% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{direct_sum}
\alias{direct_sum}
\title{Direct Sum of Matrices}
\usage{
direct_sum(x)
}
\arguments{
\item{x}{list containing matrices}
}
\value{
ds_matrix matrix containing the direct sum in list.
}
\description{
Computes the direct sum of all matrices passed in via the list.
}
\details{
Consider matrix A (mxn) and B (k x p).
A direct sum is a diagonal matrix A (+) B with dimensions (m + k) x (n + p).
}
\examples{
x = list(matrix(0,nrow=5,ncol=3),
         matrix(1,nrow=5,ncol=3))
direct_sum(x)

x = list(matrix(rnorm(15),nrow=5,ncol=3),
         matrix(rnorm(30),nrow=5,ncol=6),
         matrix(rnorm(18),nrow=2,ncol=9))
direct_sum(x)
}
\author{
James J Balamuta
}
