% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{center_matrix}
\alias{center_matrix}
\title{Center a Matrix}
\usage{
center_matrix(x)
}
\arguments{
\item{x}{A \code{matrix} with any dimensions}
}
\value{
centered_matrix A \code{matrix} with the same dimensions of X that has been centered.
}
\description{
Obtains the mean of each column of the matrix and subtracts it from the given matrix in a centering operation.
}
\details{
The application of this function to a matrix mimics the use of a centering matrix
 given by: \eqn{{C_n} = {I_n} - \frac{1}{n}{11^T}}
}
\examples{
nobs = 500
nvars = 20
x = matrix(rnorm(nobs*nvars),nrow=nobs,ncol=nvars)
r_centered = scale(x)
arma_centered1 = center_matrix(x)
}
\author{
James J Balamuta
}
\seealso{
\code{\link{cIRT}}
}

