% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_M.R
\name{get_M}
\alias{get_M}
\title{Calculate Adjacency Matrix for Graphing Methods}
\usage{
get_M(data, bw, block, item, choice, normal = TRUE)
}
\arguments{
\item{data}{A data.frame of the type described in details.}

\item{bw}{String of "b" or "w" indicating scoring of best or worst matrix.}

\item{block}{A string of the name of the block column.}

\item{item}{A string of the name of the item column.}

\item{choice}{A string of the name of the choice column.}

\item{normal}{Logical of whether or not one wants to normalize the data so 
that each row sums to 1.}
}
\value{
A symmetric adjacency matrix representing the relationship between items.
}
\description{
Takes best-worst scoring data in tidy format and transforms the relations
  between items into an adjacency matrix to be graphed.
}
\details{
This function requires data to be in a specified format. Each row must
  represent a respondent-block-label combination. That is, it indicates
  the person, the block (or trial), the item that was judged, and a column
  indicating whether it was chosen as best (+1), worst (-1), or wasn't 
  selected as either (0).
}
