% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{sim_matgaussian}
\alias{sim_matgaussian}
\title{Generate Matrix Normal Random Matrix}
\usage{
sim_matgaussian(mat_mean, mat_scale_u, mat_scale_v)
}
\arguments{
\item{mat_mean}{Mean matrix}

\item{mat_scale_u}{First scale matrix}

\item{mat_scale_v}{Second scale matrix}
}
\value{
One n x k matrix following MN distribution.
}
\description{
This function samples one matrix gaussian matrix.
}
\details{
Consider n x k matrix \eqn{Y_1, \ldots, Y_n \sim MN(M, U, V)} where M is n x k, U is n x n, and V is k x k.
\enumerate{
\item Lower triangular Cholesky decomposition: \eqn{U = P P^T} and \eqn{V = L L^T}
\item Standard normal generation: s x m matrix \eqn{Z_i = [z_{ij} \sim N(0, 1)]} in row-wise direction.
\item \eqn{Y_i = M + P Z_i L^T}
}

This function only generates one matrix, i.e. \eqn{Y_1}.
}
