% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/irf.R, R/plot.bvarirf.R
\name{irf}
\alias{irf}
\alias{plot.bvarirf}
\title{Impulse Response Function
 
A generic function used to calculate impulse response functions.}
\usage{
irf(x, ...)

\method{plot}{bvarirf}(x, ...)
}
\arguments{
\item{x}{an object of class "bvarirf", usually, a result of a call to \code{\link{irf}}.}

\item{...}{further graphical parameters.}
}
\description{
A plot function for objects of class "bvarirf".
}
\examples{

# Load data
data("e1")
e1 <- diff(log(e1)) * 100

# Generate model data
model <- gen_var(e1, p = 2, deterministic = 2,
                 iterations = 100, burnin = 10)
# Number of iterations and burnin should be much higher.

# Add prior specifications
model <- add_priors(model)

# Optain posterior draws
object <- draw_posterior(model)

# Calculate IR
ir <- irf(object, impulse = "invest", response = "cons")

# Plot IR
plot(ir)

}
