% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/thin_posterior.bvar.R
\name{thin_posterior.bvar}
\alias{thin_posterior.bvar}
\title{Thinning Posterior Draws}
\usage{
\method{thin_posterior}{bvar}(x, thin = 10)
}
\arguments{
\item{x}{an object of class \code{"bvar"}.}

\item{thin}{an integer specifying the thinning interval between successive values of posterior draws.}
}
\value{
An object of class \code{"bvar"}.
}
\description{
Thins the MCMC posterior draws in an object of class \code{"bvar"} or \code{"bvec"}.
}
\examples{

# Load data
data("e1")
e1 <- diff(log(e1)) * 100

# Obtain data matrices
model <- gen_var(e1, p = 2, deterministic = 2,
                 iterations = 100, burnin = 10)
# Chosen number of iterations and burn-in draws should be much higher.

# Add prior specifications
model <- add_priors(model)

# Obtain posterior draws
object <- draw_posterior(model)

object <- thin_posterior(object)

}
