context("c5")

test_that("c5 + predict() works", {
  skip_on_cran()
  skip_if_not_installed("C50")
  library(C50)
  library(modeldata)
  data(mlc_churn)
  c5_fit <- C5.0(x = mlc_churn[, -20], y = mlc_churn$churn)
  x <- axe_call(c5_fit)
  expect_equal(x$call, rlang::expr(dummy_call()))
  x <- axe_ctrl(c5_fit)
  expect_equal(x$control, list(NULL))
  x <- axe_fitted(c5_fit)
  expect_equal(x$output, character(0))
  x <- butcher(c5_fit)
})
