% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pair_methods.R
\name{pair_mine}
\alias{pair_mine}
\title{MINE family values}
\usage{
pair_mine(d, method = "MIC", handle.na = TRUE, ...)
}
\arguments{
\item{d}{A dataframe}

\item{method}{character vector for the MINE value to be calculated. Subset of "MIC","MAS","MEV","MCN","MICR2", "GMIC",  "TIC"}

\item{handle.na}{If TRUE uses pairwise complete observations to calculate score, otherwise NAs not handled.}

\item{...}{other arguments}
}
\value{
A tibble of class \code{pairwise} with scores for numeric variable pairs,
or NULL if there are not at least two numeric variables
}
\description{
Calculates MINE family values for every numeric variable pair in a dataset.
}
\details{
The values are calculated using \code{\link[minerva]{mine}} from \code{minerva}
}
\examples{
 pair_mine(iris)
 pair_mine(iris, method="MAS")
}
\references{
Reshef, David N., et al. "Detecting novel associations in large data sets."
science 334.6062 (2011): 1518-1524
}
