% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/init.R
\name{init}
\alias{init}
\title{Discover Build Scripts & Create Makefile}
\usage{
init(
  prefix = "build",
  sep = "_",
  path = ".",
  ignore_case = TRUE,
  command_args = ""
)
}
\arguments{
\item{prefix}{\emph{Character}. Prefix that solicited build scripts have in
common. It is trimmed and stripped in the list of \code{Makefile} targets
because of redundancy. Default to "build".}

\item{sep}{\emph{Character}. Separator between \code{prefix} and "body" of a
build script filename. It is also stripped in the list of \code{Makefile}
targets because of redundancy. Default to underscore (i.e. "_").}

\item{path}{\emph{Character}. Path being searched. Default to the project
root (i.e. ".", the current working directory, call \code{getwd()} to print
it). See \code{\link{list.files}} for more details on the topic.}

\item{ignore_case}{\emph{Logical}. Should the search be case-sensitive?
Default to FALSE.}

\item{command_args}{\emph{Single character}. Command argument(s) to include
after the recipe call. Command argument can be picked up by your script
with \code{\link{commandArgs}}. See
\code{vignette("know_your_buildr")} for more details. Empty string by
default (not in use).}
}
\value{
No return value. Called for side effects.
}
\description{
\code{init()} looks for \code{.R} scripts in a project root (current working
directory) that contain a specified prefix and separator. Then, it creates a
\code{Makefile} with rules describing how to run discovered scripts.
}
\details{
The build script names should all follow a common pattern that is both human
and machine readable. Filename should incorporate a prefix ("build" by
default) and the "body" describing what the given script builds. Those two
essential parts are separated by underscore (i.e. "_")  by default as it
helps with the readibility. Both parts are configurable (see below), but we
encourage you not to make any changes. Do not forget that build scripts are
matched for a prefix and separator concatenated together, so the script named
"build.R" won't be recognized, as it doesn't begin with "build_". Follow the
example below on how to include "build.R".
}
\examples{
\dontrun{
# if you stick with the defaults, run:
init()

# if you want to include "build.R",
# you have to tell {buildr} to
# use an empty separator, like:
init(sep = "")
}
}
\seealso{
Other functions from buildr trinity: 
\code{\link{aim}()},
\code{\link{build}()}
}
\author{
Jan Netik
}
\concept{functions from buildr trinity}
\keyword{file}
\keyword{misc}
\keyword{utilities}
