% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arrangeFunctions.R
\name{arrangePanels}
\alias{arrangePanels}
\title{Arrange Multiple bubbleHeatmap gTrees Inside a New Viewport.}
\usage{
arrangePanels(
  name,
  subTrees,
  nrow,
  ncol,
  spacer = unit(0, "cm"),
  margin = unit(0, "cm"),
  just = c(0.5, 0.5)
)
}
\arguments{
\item{name}{Character string naming the new viewport (will have suffix "VP")}

\item{subTrees}{gTrees to be arranged in the new panel}

\item{nrow}{Numeric, number of rows in the new layout}

\item{ncol}{Numeric, number of columns in the new layout}

\item{spacer}{Grid \code{\link[grid]{unit}} object specifying size of space
left between plots.}

\item{margin}{Grid \code{\link[grid]{unit}} object specifying size of margin
around panel.}

\item{just}{Numeric or character vector specifying justification of tree
viewports within panel viewport layout cells.
See \code{\link[grid]{viewport}}.}
}
\value{
List containing grobList (a list of modified gTrees) and vp, the new
viewport object.
}
\description{
The arrangePanels function creates a new viewport with a grid layout, and
directs the input trees to be drawn at positions within the new layout. The
new layout is filled by rows.
}
