% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/specify.R
\name{specify_prior_bsvarSIGN}
\alias{specify_prior_bsvarSIGN}
\title{R6 Class Representing PriorBSVAR}
\description{
The class PriorBSVARSIGN presents a prior specification for the homoskedastic bsvar model.
}
\examples{
# a prior for 5-variable example with one lag
data(optimism)
prior = specify_prior_bsvarSIGN$new(optimism, p = 1)
prior$A  # show autoregressive prior mean


## ------------------------------------------------
## Method `specify_prior_bsvarSIGN$new`
## ------------------------------------------------

# a prior for 5-variable example with one lag and stationary data
data(optimism)
prior = specify_prior_bsvarSIGN$new(optimism, p = 1)
prior$B # show autoregressive prior mean


## ------------------------------------------------
## Method `specify_prior_bsvarSIGN$get_prior`
## ------------------------------------------------

# a prior for 5-variable example with four lags
prior = specify_prior_bsvar$new(N = 5, p = 4)
prior$get_prior() # show the prior as list


## ------------------------------------------------
## Method `specify_prior_bsvarSIGN$estimate_hyper`
## ------------------------------------------------

# specify the model and set seed
set.seed(123)
data(optimism)
prior = specify_prior_bsvarSIGN$new(optimism, p = 4)

# estimate hyper parameters with adaptive Metropolis algorithm
prior$estimate_hyper(S = 10, psi = TRUE)

# trace plot
hyper = t(prior$hyper)
colnames(hyper) = c("mu", "delta", "lambda", paste("psi", 1:5, sep = ""))
plot.ts(hyper)

}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{p}}{a positive integer - the number of lags.}

\item{\code{hyper}}{a \code{(N+3)xS} matrix of hyper-parameters \eqn{\mu, \delta, \lambda, \psi}.}

\item{\code{A}}{a \code{NxK} normal prior mean matrix for the autoregressive 
parameters.}

\item{\code{V}}{a \code{KxK} matrix determining  the normal prior column-specific 
covariance for the autoregressive parameters.}

\item{\code{S}}{an \code{NxN} matrix determining the inverted-Wishart prior scale 
of error terms covariance matrix.}

\item{\code{nu}}{a positive scalar greater than \code{N+1} - the shape of the 
inverted-Wishart prior for error terms covariance matrix.}

\item{\code{data}}{an \code{TxN} matrix of observations.}

\item{\code{Y}}{an \code{NxT} matrix of dependent variables.}

\item{\code{X}}{an \code{KxT} matrix of independent variables.}

\item{\code{Ysoc}}{an \code{NxN} matrix with the sum-of-coefficients dummy observations.}

\item{\code{Xsoc}}{an \code{KxN} matrix with the sum-of-coefficients dummy observations.}

\item{\code{Ysur}}{an \code{NxN} matrix with the single-unit-root dummy observations.}

\item{\code{Xsur}}{an \code{KxN} matrix with the single-unit-root dummy observations.}

\item{\code{mu.scale}}{a positive scalar - the shape of the gamma prior for \eqn{\mu}.}

\item{\code{mu.shape}}{a positive scalar - the shape of the gamma prior for \eqn{\mu}.}

\item{\code{delta.scale}}{a positive scalar - the shape of the gamma prior for \eqn{\delta}.}

\item{\code{delta.shape}}{a positive scalar - the shape of the gamma prior for \eqn{\delta}.}

\item{\code{lambda.scale}}{a positive scalar - the shape of the gamma prior for \eqn{\lambda}.}

\item{\code{lambda.shape}}{a positive scalar - the shape of the gamma prior for \eqn{\lambda}.}

\item{\code{psi.scale}}{a positive scalar - the shape of the inverted gamma prior for \eqn{\psi}.}

\item{\code{psi.shape}}{a positive scalar - the shape of the inverted gamma prior for \eqn{\psi}.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-PriorBSVARSIGN-new}{\code{specify_prior_bsvarSIGN$new()}}
\item \href{#method-PriorBSVARSIGN-get_prior}{\code{specify_prior_bsvarSIGN$get_prior()}}
\item \href{#method-PriorBSVARSIGN-estimate_hyper}{\code{specify_prior_bsvarSIGN$estimate_hyper()}}
\item \href{#method-PriorBSVARSIGN-clone}{\code{specify_prior_bsvarSIGN$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PriorBSVARSIGN-new"></a>}}
\if{latex}{\out{\hypertarget{method-PriorBSVARSIGN-new}{}}}
\subsection{Method \code{new()}}{
Create a new prior specification PriorBSVAR.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{specify_prior_bsvarSIGN$new(
  data,
  p,
  exogenous = NULL,
  stationary = rep(FALSE, ncol(data))
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{the \code{TxN} data matrix of observations.}

\item{\code{p}}{a positive integer - the autoregressive lag order of the SVAR model.}

\item{\code{exogenous}}{a \code{Txd} matrix of exogenous variables.}

\item{\code{stationary}}{an \code{N} logical vector - its element set to \code{FALSE} sets 
the prior mean for the autoregressive parameters of the \code{N}th equation to the white noise process, 
otherwise to random walk.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new prior specification PriorBSVARSIGN.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# a prior for 5-variable example with one lag and stationary data
data(optimism)
prior = specify_prior_bsvarSIGN$new(optimism, p = 1)
prior$B # show autoregressive prior mean

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PriorBSVARSIGN-get_prior"></a>}}
\if{latex}{\out{\hypertarget{method-PriorBSVARSIGN-get_prior}{}}}
\subsection{Method \code{get_prior()}}{
Returns the elements of the prior specification PriorBSVAR as a \code{list}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{specify_prior_bsvarSIGN$get_prior()}\if{html}{\out{</div>}}
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# a prior for 5-variable example with four lags
prior = specify_prior_bsvar$new(N = 5, p = 4)
prior$get_prior() # show the prior as list

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PriorBSVARSIGN-estimate_hyper"></a>}}
\if{latex}{\out{\hypertarget{method-PriorBSVARSIGN-estimate_hyper}{}}}
\subsection{Method \code{estimate_hyper()}}{
Estimates hyper-parameters with adaptive Metropolis algorithm.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{specify_prior_bsvarSIGN$estimate_hyper(
  S = 10000,
  burn_in = S/2,
  mu = FALSE,
  delta = FALSE,
  lambda = TRUE,
  psi = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{S}}{number of MCMC draws.}

\item{\code{burn_in}}{number of burn-in draws.}

\item{\code{mu}}{whether to estimate the hyper-parameter in the 
sum-of-coefficients dummy prior.}

\item{\code{delta}}{whether to estimate the hyper-parameter in the 
single-unit-root dummy prior.}

\item{\code{lambda}}{whether to estimate the hyper-parameter of the 
shrinkage in the Minnesota prior.}

\item{\code{psi}}{whether to estimate the hyper-parameter of the 
variances in the Minnesota prior.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# specify the model and set seed
set.seed(123)
data(optimism)
prior = specify_prior_bsvarSIGN$new(optimism, p = 4)

# estimate hyper parameters with adaptive Metropolis algorithm
prior$estimate_hyper(S = 10, psi = TRUE)

# trace plot
hyper = t(prior$hyper)
colnames(hyper) = c("mu", "delta", "lambda", paste("psi", 1:5, sep = ""))
plot.ts(hyper)

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PriorBSVARSIGN-clone"></a>}}
\if{latex}{\out{\hypertarget{method-PriorBSVARSIGN-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{specify_prior_bsvarSIGN$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
