% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accordion_sidebar.R, R/append.R, R/set_opts.R
\name{bs_accordion_sidebar}
\alias{bs_accordion_sidebar}
\alias{use_bs_accordion_sidebar}
\alias{bs_append.bsplus_accordion_sidebar}
\alias{bs_set_opts.bsplus_accordion_sidebar}
\title{Accordion-sidebar panel-group}
\usage{
bs_accordion_sidebar(
  id,
  spec_side = c(width = 4, offset = 0),
  spec_main = c(width = 8, offset = 0),
  position = c("left", "right")
)

use_bs_accordion_sidebar()

\method{bs_append}{bsplus_accordion_sidebar}(tag, title_side, content_side, content_main, ...)

\method{bs_set_opts}{bsplus_accordion_sidebar}(
  tag,
  panel_type_active = "success",
  panel_type_inactive = "primary",
  use_main_enclosure = TRUE,
  ...
)
}
\arguments{
\item{id}{character, unique id for accordion-sidebar \verb{<div/>},
also serves as root id for panels appended using \code{bs_append()}}

\item{spec_side}{numeric, column specification for sidebar panels}

\item{spec_main}{numeric, column specification for main panels}

\item{position}{character, indicates where to put the sidebar panels with
respect to the main panels}

\item{tag}{\verb{htmltools::[tag][htmltools::tag]},
accordion-sidebar \verb{<div/>} to which to append a panel}

\item{title_side}{character (HTML) or \verb{htmltools::[tagList][htmltools::tagList]},
title for the sidebar panel}

\item{content_side}{character (HTML) or \verb{htmltools::[tagList][htmltools::tagList]},
content for the sidebar panel}

\item{content_main}{character (HTML) or \verb{htmltools::[tagList][htmltools::tagList]},
content for the main panel}

\item{...}{other arguments (not used)}

\item{panel_type_active}{character, indicated bootstrap type for active-panel header,
one of \code{c("default", "primary", "success", "info", "warning", "danger")}}

\item{panel_type_inactive}{character, indicated bootstrap type for inactive-panel header,
one of \code{c("default", "primary", "success", "info", "warning", "danger")}}

\item{use_main_enclosure}{logical, indicates if main content is to be wrapped in a
Bootstrap panel}
}
\value{
\code{bsplus_accsidebar} object (\verb{htmltools::[tag][htmltools::tag]},
\verb{<div/>})
}
\description{
Combines Bootstrap accordion with
the functionality of \verb{shiny::[sidebarLayout][shiny::sidebarLayout]},
allowing you to add another dimension to your \strong{shiny} apps.
}
\details{
If you use a \code{bs_accordion_sidebar()}, you will have to call the function
\code{use_bs_accordion_sidebar()} somewhere in your UI. This attaches some
JavaScript needed for your accordion sidebar to work properly.

All of these functions return a \code{bsplus_accsidebar} object,
(which is also an \verb{htmltools::[tag][htmltools::tag]}, \verb{<div/>}), so you can
compose an accordion sidebar by piping. There are three parts to this system:

\enumerate{
\item{A constructor function for the accordion-sidebar, \code{bs_accordion_sidebar()}}
\item{A function to set options for subsequent panels, \code{bs_set_opts()}}
\item{A function to append a panel-set to an accordion-sidebar, \code{bs_append()}}
}

The verb \emph{append} is used to signify that you can append an arbitrary
number of panels-sets to an accordion-sidebar.

For the constructor, \code{bs_accordion_sidebar()},
it is your responsibility to ensure that \code{id} is unique
among HTML elements in your page. If you have non-unique \code{id}'s, strange things may
happen to your page.
}
\examples{
bs_accordion_sidebar(id = "meet_the_beatles") \%>\%
  bs_append(
    title_side = "John Lennon",
    content_side = "Rhythm guitar, vocals",
    content_main = "Dear Prudence"
  ) \%>\%
  bs_append(
    title_side = "Paul McCartney",
    content_side = "Bass guitar, vocals",
    content_main = "Blackbird"
  )
\dontrun{
use_bs_accordion_sidebar()
}
}
