% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nav-update.R
\name{nav_prepend}
\alias{nav_prepend}
\alias{nav_append}
\title{Append or prepend nav item to a dropdown menu}
\usage{
nav_prepend(
  id,
  nav,
  menu_title,
  select = FALSE,
  session = get_current_session()
)

nav_append(
  id,
  nav,
  menu_title,
  select = FALSE,
  session = get_current_session()
)
}
\arguments{
\item{id}{a character string used to identify the nav container.}

\item{nav}{a \code{\link[=nav_panel]{nav_panel()}} item.}

\item{menu_title}{The title of a \code{\link[=nav_menu]{nav_menu()}}.}

\item{select}{Should \code{nav} be selected upon being inserted?}

\item{session}{a shiny session object (the default should almost always be used).}
}
\description{
Exported for use by \code{\link[shiny:insertTab]{shiny::prependTab()}}/\code{\link[shiny:insertTab]{shiny::appendTab()}}. These
functions have been superseded by \code{\link[=nav_insert]{nav_insert()}} (i.e.,
\code{\link[shiny:insertTab]{shiny::insertTab()}}), since it can do everything these functions do (i.e.,
add a \code{\link[=nav_panel]{nav_panel()}} to the start or end of a \code{\link[=nav_menu]{nav_menu()}}) and more (i.e., insert a
\code{\link[=nav_panel]{nav_panel()}} anywhere inside a nav container).
}
\keyword{internal}
