% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/record_delete_wrappers.R
\name{bs_delete_list}
\alias{bs_delete_list}
\title{Delete a list}
\usage{
bs_delete_list(
  rkey,
  user = get_bluesky_user(),
  pass = get_bluesky_pass(),
  auth = bs_auth(user, pass)
)
}
\arguments{
\item{rkey}{Character, length 1. The CID of the version of the record. If not specified, then return the most recent version.}

\item{user}{Character. User name to log in with. Defaults to \code{get_bluesky_user()}.}

\item{pass}{Character. App password to log in with. Defaults to \code{get_bluesky_pass()}.}

\item{auth}{Authentication information. Defaults to \code{bs_auth(user, pass)}.}
}
\value{
an \code{httr2} status code
}
\description{
Delete a list
}
\section{Lexicon references}{

\href{https://github.com/bluesky-social/atproto/blob/main/lexicons/app/bsky/graph/list.json}{graph/list.json (2024-12-01)}
\href{https://github.com/bluesky-social/atproto/blob/main/lexicons/com/atproto/repo/deleteRecord.json}{repo/deleteRecord.json (2024-12-01)}
}

\section{Function introduced}{

\code{v0.2.0} (2024-12-01)
}

\examples{
\dontshow{if (has_bluesky_pass() && has_bluesky_user()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
lst <- bs_new_list(name = 'test list bskyr', purpose = 'curatelist')
bs_delete_list(bs_extract_record_key(lst$uri))
\dontshow{\}) # examplesIf}
}
\concept{repo}
