% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loo_validation.R
\name{loo_validation.bgmfit}
\alias{loo_validation.bgmfit}
\alias{loo_validation}
\title{Perform leave-one-out (loo) cross-validation}
\usage{
\method{loo_validation}{bgmfit}(
  model,
  resp = NULL,
  cores = 1,
  deriv = 0,
  usesavedfuns = FALSE,
  clearenvfuns = FALSE,
  envir = NULL,
  ...
)

loo_validation(model, ...)
}
\arguments{
\item{model}{An object of class \code{bgmfit}.}

\item{resp}{A character string to specify response variable when processing
posterior draws for the univariate-by-subgroup and multivariate models (see
\code{\link[=bsitar]{bsitar()}} for details on fitting univariate-by-subgroup and
multivariate models). For univariate model, \code{resp = NULL} (default).
Note that argument \code{resp} must be specified for the
univariate-by-subgroup and multivariate models otherwise it will result in
an error. On the other hand, argument \code{resp} must be \code{NULL} for
the univariate model. The default setting is \code{resp = NULL} assuming a
univariate model.}

\item{cores}{Number of cores to be used when running the parallel
computations by setting the option \code{future = TRUE}. On non-Windows
systems this argument can be set globally via the mc.cores option. For the
default \code{NULL} option, the number of cores are set automatically by
calling the \code{\link[future:re-exports]{future::availableCores()}}. The number of cores used are the
maximum number of cores avaialble minus one, i.e.,
\code{future::availableCores() - 1}.}

\item{deriv}{Must be \code{NULL}.}

\item{usesavedfuns}{A logical (default \code{FALSE}) to indicate whether to
use the already exposed and saved \code{Stan} functions. This is for
internal use when testing the function and not used routinely.}

\item{clearenvfuns}{A logical (default \code{FALSE}) to indicate whether to
clear the exposed function from the environment.}

\item{envir}{Environment of function evaluation. The default is \code{NULL}
which will set \code{parent.frame()} as default environment. Note that
since most of post processing functions are based on \pkg{brms}, it is
strongly advised to set \code{globalenv()} (or \code{.GlobalEnv}) as
environment. This is particularly true for derivatives such as velocity
curve.}

\item{...}{Additional arguments passed to the \code{\link[brms:loo.brmsfit]{brms::loo()}} function.
Please see \code{brms::loo} for details on various options available.}
}
\value{
If only one model object is provided, then an object of class
\code{loo} is returned. If multiple objects are provided, an object of
class \code{loolist}.
}
\description{
The \strong{loo_validation()} is a wrapper around the
\code{\link[brms:loo.brmsfit]{brms::loo()}} function to perform approximate leave-one-out
cross-validation based on the posterior likelihood. See \code{\link[brms:loo.brmsfit]{brms::loo()}} for
details.
}
\details{
See \code{\link[brms]{loo_compare}} for details on model comparisons.
 For \code{brmsfit} objects, \code{LOO} is an alias of \code{loo}.
 Use method \code{\link[brms]{add_criterion}} to store
 information criteria in the fitted model object for later usage.
}
\examples{

# Fit Bayesian SITAR model 

# To avoid fitting the model which takes time, the model  
# fit has already been saved as 'berkeley_mfit.rda' file.
# See examples section of the main function for details on the model fit.

model <- berkeley_mfit

\donttest{
loo_validation(model, cores = 1)
}


}
\seealso{
\code{\link[brms:loo.brmsfit]{brms::loo()}}
}
\author{
Satpal Sandhu  \email{satpal.sandhu@bristol.ac.uk}
}
