% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bruceR_stats_04_regress.R
\name{grand_mean_center}
\alias{grand_mean_center}
\title{Grand-mean centering.}
\usage{
grand_mean_center(data, vars = names(data), std = FALSE, add.suffix = "")
}
\arguments{
\item{data}{Data object.}

\item{vars}{Variable(s) to be centered.}

\item{std}{Standardized or not. Default is \code{FALSE}.}

\item{add.suffix}{The suffix of the centered variable(s).
Default is \code{""}. You may set it to \code{"_c"}, \code{"_center"}, etc.}
}
\value{
A new data object containing the centered variable(s).
}
\description{
Compute grand-mean centered variables.
Usually used for GLM interaction-term predictors and HLM level-2 predictors.
}
\examples{
d = data.table(a=1:5, b=6:10)

d.c = grand_mean_center(d, "a")
d.c

d.c = grand_mean_center(d, c("a", "b"), add.suffix="_center")
d.c

}
\seealso{
\code{\link{group_mean_center}}
}
