% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bruceR_basic.R
\name{export}
\alias{export}
\title{Export data to a file (TXT, CSV, Excel, SPSS, Stata, ...) or clipboard.}
\usage{
export(
  x,
  file,
  sheet = NULL,
  encoding = NULL,
  header = "auto",
  overwrite = TRUE
)
}
\arguments{
\item{x}{Any R object, usually a data frame (\code{data.frame}, \code{data.table}, \code{tbl_df}).
Multiple R objects should be included in a \emph{named} \code{list} (see examples).

If you want to save R objects other than a data frame (e.g., model results),
you'd better specify \code{file} with extensions .rda, .rdata, or .Rdata.}

\item{file}{File name (with extension).
If unspecified, then data will be exported to clipboard.}

\item{sheet}{[Only for Excel] Excel sheet name(s).
Default is Sheet1, Sheet2, ...
You may specify multiple sheet names in a character vector
\code{c()} with the \emph{same length} as \code{x} (see examples).}

\item{encoding}{File encoding. Default is \code{NULL}.
Alternatives can be \code{"UTF-8"}, \code{"GBK"}, \code{"CP936"}, etc.

If you find messy code for Chinese text in the exported data (often in CSV when opened with Excel),
it is usually effective to set \code{encoding="GBK"} or \code{encoding="CP936"}.}

\item{header}{Does the first row contain column names (\code{TRUE} or \code{FALSE})? Default is \code{"auto"}.}

\item{overwrite}{Overwrite the existing file (if any)? Default is \code{TRUE}.}
}
\value{
No return value.
}
\description{
Export data to a file, with format automatically judged from file extension.
This function is inspired by \code{\link[rio:export]{rio::export()}}
and has several modifications.
Its purpose is to avoid using lots of \code{write_xxx()} functions in your code
and to provide one tidy function for data export.

It supports many file formats and uses corresponding R functions:

\itemize{
  \item Plain text (.txt, .csv, .csv2, .tsv, .psv), using \code{\link[data.table:fwrite]{data.table::fwrite()}};
  if the \code{encoding} argument is specified, using \code{\link[utils:write.table]{utils::write.table()}} instead
  \item Excel (.xls, .xlsx), using \code{\link[openxlsx:write.xlsx]{openxlsx::write.xlsx()}}
  \item SPSS (.sav), using \code{\link[haven:read_spss]{haven::write_sav()}}
  \item Stata (.dta), using \code{\link[haven:read_dta]{haven::write_dta()}}
  \item R objects (.rda, .rdata, .Rdata), using \code{\link[base:save]{base::save()}}
  \item R serialized objects (.rds), using \code{\link[base:readRDS]{base::saveRDS()}}
  \item Clipboard (on Windows and Mac OS), using \code{\link[clipr:write_clip]{clipr::write_clip()}}
  \item Other formats, using \code{\link[rio:export]{rio::export()}}
}
}
\examples{
\dontrun{

  export(airquality)  # paste to clipboard
  export(airquality, file="mydata.csv")
  export(airquality, file="mydata.sav")

  export(list(airquality, npk), file="mydata.xlsx")  # Sheet1, Sheet2
  export(list(air=airquality, npk=npk), file="mydata.xlsx")  # a named list
  export(list(airquality, npk), sheet=c("air", "npk"), file="mydata.xlsx")

  export(list(a=1, b=npk, c="character"), file="abc.Rdata")  # .rda, .rdata
  d = import("abc.Rdata")  # load only the first object and rename it to `d`
  load("abc.Rdata")  # load all objects with original names to environment

  export(lm(yield ~ N*P*K, data=npk), file="lm_npk.Rdata")
  model = import("lm_npk.Rdata")
  load("lm_npk.Rdata")  # because x is unnamed, the object has a name "List1"

  export(list(m1=lm(yield ~ N*P*K, data=npk)), file="lm_npk.Rdata")
  model = import("lm_npk.Rdata")
  load("lm_npk.Rdata")  # because x is named, the object has a name "m1"
}

}
\seealso{
\code{\link{import}}, \code{\link{print_table}}
}
