% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/priors.R
\name{Prior_lambda}
\alias{Prior_lambda}
\alias{dprior_lambda}
\alias{pprior_lambda}
\alias{rprior_lambda}
\alias{sprior_lambda}
\title{Prior distribution on the incidence rate in the treated group}
\usage{
dprior_lambda(lambda, a, b, c, d, S, T)

rprior_lambda(n, a, b, c, d, S, T)

pprior_lambda(q, a, b, c, d, S, T, ...)

sprior_lambda(a, b, c, d, S, T, ...)
}
\arguments{
\item{lambda,q}{vector of quantiles}

\item{a,b}{non-negative shape and rate parameter of the Gamma prior distribution on \eqn{\mu}}

\item{c,d}{non-negative shape parameters of the prior distribution on \eqn{\phi}}

\item{S,T}{sample sizes in control group and treated group}

\item{n}{number of observations to be simulated}

\item{...}{other arguments passed to \code{\link{genhypergeo}} through \code{\link{pGB2}},
such as \code{series=FALSE} to use the continued fraction expansion,
or passed to \code{\link{summary_GB2}} (for \code{sprior_lambda})}
}
\value{
\code{dprior_lambda} gives the density, \code{pprior_lambda} the distribution function
(see Details), \code{rprior_lambda} samples from the distribution, and
\code{rprior_lambda} gives a summary of the distribution.
}
\description{
Density, distribution function (see Details) and random generation for the prior distribution on
the rate in the treated group.  The prior distribution on the incidence rate \eqn{\lambda} is not to
be set by the user: it is induced by the user-specified prior on \eqn{\mu}
and \eqn{\phi}.








}
\details{
The pdf of the prior distribution on the incidence rate \eqn{\lambda} involves
the Kummer confluent hypergeometric function of the second kind.
The cdf involves the generalized hypergeometric function. Its current implementation
does not work when \code{a-c} is an integer.
}
\note{
\code{Prior_lambda} is a generic name for the functions documented.
}
\examples{
curve(dprior_lambda(x, 2, 2, 2.5, 2, 10, 10), from=0, to=5)
sprior_lambda(2, 2, 2.5, 2, 10, 10)
}

