% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats-decompose-tidiers.R
\name{augment.stl}
\alias{augment.stl}
\title{Augment data with information from a(n) stl object}
\usage{
\method{augment}{stl}(x, data = NULL, weights = TRUE, ...)
}
\arguments{
\item{x}{An \code{stl} object returned from \code{\link[stats:stl]{stats::stl()}}.}

\item{data}{Ignored, included for consistency with the augment generic signature only.}

\item{weights}{Logical indicating whether or not to include the robust
weights in the output.}

\item{...}{Additional arguments. Not used. Needed to match generic
signature only. \strong{Cautionary note:} Misspelled arguments will be
absorbed in \code{...}, where they will be ignored. If the misspelled
argument has a default value, the default value will be used.
For example, if you pass \code{conf.lvel = 0.9}, all computation will
proceed using \code{conf.level = 0.95}. Two exceptions here are:
\itemize{
\item \code{tidy()} methods will warn when supplied an \code{exponentiate} argument if
it will be ignored.
\item \code{augment()} methods will warn when supplied a \code{newdata} argument if it
will be ignored.
}}
}
\value{
A \link[tibble:tibble]{tibble::tibble} with one row for each observation in the
original times series:

\item{\code{.seasonal}}{The seasonal component of the decomposition.}
\item{\code{.trend}}{The trend component of the decomposition.}
\item{\code{.remainder}}{The remainder, or "random" component of the
decomposition.}
\item{\code{.weight}}{The final robust weights, if requested.}
\item{\code{.seasadj}}{The seasonally adjusted (or "deseasonalised")
series.}
}
\description{
Augment accepts a model object and a dataset and adds
information about each observation in the dataset. Most commonly, this
includes predicted values in the \code{.fitted} column, residuals in the
\code{.resid} column, and standard errors for the fitted values in a \code{.se.fit}
column. New columns always begin with a \code{.} prefix to avoid overwriting
columns in the original dataset.

Users may pass data to augment via either the \code{data} argument or the
\code{newdata} argument. If the user passes data to the \code{data} argument,
it \strong{must} be exactly the data that was used to fit the model
object. Pass datasets to \code{newdata} to augment data that was not used
during model fitting. This still requires that at least all predictor
variable columns used to fit the model are present. If the original outcome
variable used to fit the model is not included in \code{newdata}, then no
\code{.resid} column will be included in the output.

Augment will often behave differently depending on whether \code{data} or
\code{newdata} is given. This is because there is often information
associated with training observations (such as influences or related)
measures that is not meaningfully defined for new observations.

For convenience, many augment methods provide default \code{data} arguments,
so that \code{augment(fit)} will return the augmented training data. In these
cases, augment tries to reconstruct the original data based on the model
object with varying degrees of success.

The augmented dataset is always returned as a \link[tibble:tibble]{tibble::tibble} with the
\strong{same number of rows} as the passed dataset. This means that the passed
data must be coercible to a tibble. If a predictor enters the model as part
of a matrix of covariates, such as when the model formula uses
\code{\link[splines:ns]{splines::ns()}}, \code{\link[stats:poly]{stats::poly()}}, or \code{\link[survival:Surv]{survival::Surv()}}, it is represented
as a matrix column.

We are in the process of defining behaviors for models fit with various
\code{na.action} arguments, but make no guarantees about behavior when data is
missing at this time.
}
\seealso{
\code{\link[=augment]{augment()}}, \code{\link[stats:stl]{stats::stl()}}

Other decompose tidiers: 
\code{\link{augment.decomposed.ts}()}
}
\concept{decompose tidiers}
