% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list-optim-tidiers.R
\name{tidy_optim}
\alias{tidy_optim}
\alias{optim_tidiers}
\alias{tidy.optim}
\title{Tidy a(n) optim object masquerading as list}
\usage{
tidy_optim(x, ...)
}
\arguments{
\item{x}{A list returned from \code{\link[stats:optim]{stats::optim()}}.}

\item{...}{Additional arguments. Not used. Needed to match generic
signature only. \strong{Cautionary note:} Misspelled arguments will be
absorbed in \code{...}, where they will be ignored. If the misspelled
argument has a default value, the default value will be used.
For example, if you pass \code{conf.lvel = 0.9}, all computation will
proceed using \code{conf.level = 0.95}. Additionally, if you pass
\code{newdata = my_tibble} to an \code{\link[=augment]{augment()}} method that does not
accept a \code{newdata} argument, it will use the default value for
the \code{data} argument.}
}
\description{
Broom tidies a number of lists that are effectively S3
objects without a class attribute. For example, \code{\link[stats:optim]{stats::optim()}},
\link[base:svd]{svd()} and \code{\link[akima:interp]{akima::interp()}} produce consistent output, but
because they do not have a class attribute, they cannot be handled by S3
dispatch.

These functions look at the elements of a list and determine if there is
an appropriate tidying method to apply to the list. Those tidiers are
themselves are implemented as functions of the form \verb{tidy_<function>}
or \verb{glance_<function>} and are not exported (but they are documented!).

If no appropriate tidying method is found, throws an error.
}
\note{
This function assumes that the provided objective function is a negative
log-likelihood function. Results will be invalid if an incorrect
function is supplied.

tidy(o)
glance(o)
}
\examples{

f <- function(x) (x[1] - 2)^2 + (x[2] - 3)^2 + (x[3] - 8)^2
o <- optim(c(1, 1, 1), f)

}
\seealso{
\code{\link[=tidy]{tidy()}}, \code{\link[stats:optim]{stats::optim()}}

Other list tidiers: 
\code{\link{glance_optim}()},
\code{\link{list_tidiers}},
\code{\link{tidy_irlba}()},
\code{\link{tidy_svd}()},
\code{\link{tidy_xyz}()}
}
\concept{list tidiers}
\value{
A \code{\link[tibble:tibble]{tibble::tibble()}} with columns:
  \item{parameter}{The parameter being modeled.}
  \item{std.error}{The standard error of the regression term.}
  \item{value}{The value/estimate of the component. Results from data reshaping.}
\code{std.error} is only provided as a column if the Hessian is calculated.
}
