% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/betareg_tidiers.R
\name{betareg_tidiers}
\alias{augment.betareg}
\alias{betareg_tidiers}
\alias{glance.betareg}
\alias{tidy.betareg}
\title{Tidy betareg objects from the betareg package}
\usage{
\method{tidy}{betareg}(x, conf.int = FALSE, conf.level = 0.95, ...)

\method{augment}{betareg}(x, data = stats::model.frame(x), newdata,
  type.predict, type.residuals, ...)

\method{glance}{betareg}(x, ...)
}
\arguments{
\item{x}{A "betareg" object}

\item{conf.int}{whether to include a confidence interval}

\item{conf.level}{confidence level of the interval, used only if
\code{conf.int=TRUE}}

\item{...}{Extra arguments, not used}

\item{data}{Original data frame the regression was fit on}

\item{newdata}{New data frame to use for prediction}

\item{type.predict}{Type of predictions to calculate}

\item{type.residuals}{Type of residuals to calculate}
}
\value{
All tidying methods return a data.frame without rownames, whose
structure depends on the method chosen.

tidy returns a data.frame with one row for each term used to predict
the mean, along with at least one term used to predict phi (the inverse of
the variance). It starts with the column \code{component} containing either
"mean" or "precision" to describe which is being modeled, then has the same
columns as tidied linear models or glm's (see \code{\link{lm_tidiers}}).

augment returns the original data, along with new columns describing
each observation:
  \item{.fitted}{Fitted values of model}
  \item{.resid}{Residuals}
  \item{.cooksd}{Cooks distance, \code{\link{cooks.distance}}}

\code{glance} returns a one-row data.frame with the columns
  \item{pseudo.r.squared}{the deviance of the null model}
  \item{logLik}{the data's log-likelihood under the model}
  \item{AIC}{the Akaike Information Criterion}
  \item{BIC}{the Bayesian Information Criterion}
  \item{df.residual}{residual degrees of freedom}
  \item{df.null}{degrees of freedom under the null}
}
\description{
Tidy beta regression objects into summarized coefficients, add their fitted values
and residuals, or find their model parameters.
}
\examples{

if (require("betareg", quietly = TRUE)) {
  data("GasolineYield", package = "betareg")

  mod <- betareg(yield ~ batch + temp, data = GasolineYield)
  
  mod
  tidy(mod)
  tidy(mod, conf.int = TRUE)
  tidy(mod, conf.int = TRUE, conf.level = .99)
  
  head(augment(mod))
  
  glance(mod)
}

}

