% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy_add_contrasts.R
\name{tidy_add_contrasts}
\alias{tidy_add_contrasts}
\title{Add contrasts type for categorical variables}
\usage{
tidy_add_contrasts(x, model = tidy_get_model(x), quiet = FALSE)
}
\arguments{
\item{x}{(\code{data.frame})\cr
A tidy tibble as produced by \verb{tidy_*()} functions.}

\item{model}{(a model object, e.g. \code{glm})\cr
The corresponding model, if not attached to \code{x}.}

\item{quiet}{(\code{logical})\cr
Whether broom.helpers should not return a message
when \code{tidy_disambiguate_terms()} was already applied}
}
\description{
Add a \code{contrasts} column corresponding to contrasts used for a
categorical variable and a \code{contrasts_type} column equal to
"treatment", "sum", "poly", "helmert", "other" or "no.contrast".
}
\details{
If the \code{variable} column is not yet available in \code{x},
\code{\link[=tidy_identify_variables]{tidy_identify_variables()}} will be automatically applied.
}
\examples{
df <- Titanic |>
  dplyr::as_tibble() |>
  dplyr::mutate(Survived = factor(Survived, c("No", "Yes")))

glm(
  Survived ~ Class + Age + Sex,
  data = df, weights = df$n, family = binomial,
  contrasts = list(Age = contr.sum, Class = "contr.helmert")
) |>
  tidy_and_attach() |>
  tidy_add_contrasts()
}
\seealso{
Other tidy_helpers: 
\code{\link{tidy_add_coefficients_type}()},
\code{\link{tidy_add_estimate_to_reference_rows}()},
\code{\link{tidy_add_header_rows}()},
\code{\link{tidy_add_n}()},
\code{\link{tidy_add_pairwise_contrasts}()},
\code{\link{tidy_add_reference_rows}()},
\code{\link{tidy_add_term_labels}()},
\code{\link{tidy_add_variable_labels}()},
\code{\link{tidy_attach_model}()},
\code{\link{tidy_disambiguate_terms}()},
\code{\link{tidy_identify_variables}()},
\code{\link{tidy_plus_plus}()},
\code{\link{tidy_remove_intercept}()},
\code{\link{tidy_select_variables}()}
}
\concept{tidy_helpers}
