% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/marginal_tidiers.R
\name{tidy_avg_slopes}
\alias{tidy_avg_slopes}
\title{Marginal Slopes / Effects with \code{marginaleffects::avg_slopes()}}
\usage{
tidy_avg_slopes(x, conf.int = TRUE, conf.level = 0.95, ...)
}
\arguments{
\item{x}{a model}

\item{conf.int}{logical indicating whether or not to include a confidence
interval in the tidied output}

\item{conf.level}{the confidence level to use for the confidence interval}

\item{...}{additional parameters passed to
\code{marginaleffects::avg_slopes()}}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
Use \code{marginaleffects::avg_slopes()} to estimate marginal slopes / effects and
return a tibble tidied in a way that it could be used by \code{broom.helpers}
functions. See \code{marginaleffects::avg_slopes()} for a list of supported
models.
}
\details{
By default, \code{marginaleffects::avg_slopes()} estimate average marginal
effects (AME): an effect is computed for each observed value in the original
dataset before being averaged. Marginal Effects at the Mean (MEM) could be
computed by specifying \code{newdata = "mean"}. Other types of marginal effects
could be computed. Please refer to the documentation page of
\code{marginaleffects::avg_slopes()}.

For more information, see \code{vignette("marginal_tidiers", "broom.helpers")}.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Average Marginal Effects (AME)

df <- Titanic |>
  dplyr::as_tibble() |>
  tidyr::uncount(n) |>
  dplyr::mutate(Survived = factor(Survived, c("No", "Yes")))
mod <- glm(
  Survived ~ Class + Age + Sex,
  data = df, family = binomial
)
tidy_avg_slopes(mod)
tidy_plus_plus(mod, tidy_fun = tidy_avg_slopes)

mod2 <- lm(Petal.Length ~ poly(Petal.Width, 2) + Species, data = iris)
tidy_avg_slopes(mod2)

# Marginal Effects at the Mean (MEM)
tidy_avg_slopes(mod, newdata = "mean")
tidy_plus_plus(mod, tidy_fun = tidy_avg_slopes, newdata = "mean")
\dontshow{\}) # examplesIf}
}
\seealso{
\code{marginaleffects::avg_slopes()}

Other marginal_tieders: 
\code{\link{tidy_all_effects}()},
\code{\link{tidy_avg_comparisons}()},
\code{\link{tidy_ggpredict}()},
\code{\link{tidy_marginal_contrasts}()},
\code{\link{tidy_marginal_means}()},
\code{\link{tidy_marginal_predictions}()},
\code{\link{tidy_margins}()}
}
\concept{marginal_tieders}
