% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy_plus_plus.R
\name{tidy_plus_plus}
\alias{tidy_plus_plus}
\title{Tidy a model and compute additional informations}
\usage{
tidy_plus_plus(
  model,
  tidy_fun = broom::tidy,
  conf.int = TRUE,
  exponentiate = FALSE,
  variable_labels = NULL,
  term_labels = NULL,
  add_reference_rows = TRUE,
  add_estimate_to_reference_rows = TRUE,
  add_header_rows = FALSE,
  show_single_row = NULL,
  intercept = FALSE,
  keep_model = FALSE,
  quiet = FALSE,
  strict = FALSE,
  ...
)
}
\arguments{
\item{model}{a model to be attached/tidied}

\item{tidy_fun}{option to specify a custom tidier function}

\item{conf.int}{should confidence intervals be computed? (see \code{\link[broom:reexports]{broom::tidy()}})}

\item{exponentiate}{logical indicating whether or not to exponentiate the
coefficient estimates. This is typical for logistic and multinomial regressions,
but a bad idea if there is no log or logit link. Defaults to \code{FALSE}.}

\item{variable_labels}{a named list or a named vector of custom variable labels}

\item{term_labels}{a named list or a named vector of custom term labels}

\item{add_reference_rows}{should reference rows be added?}

\item{add_estimate_to_reference_rows}{should an estimate value be added to reference rows?}

\item{add_header_rows}{should header rows be added?}

\item{show_single_row}{a vector indicating the names of binary
variables that should be displayed on a single row, when
\code{add_header_rows} is \code{TRUE}}

\item{intercept}{should the intercept(s) be included?}

\item{keep_model}{should the model be kept as an attribute of the final result?}

\item{quiet}{logical argument whether broom.helpers should return an error
when requested output cannot be generated. Default is FALSE}

\item{strict}{logical argument whether broom.helpers should return an error
when requested output cannot be generated. Default is FALSE}

\item{...}{other arguments passed to \code{tidy_fun()}}
}
\description{
This function will apply sequentially:
\itemize{
\item \code{\link[=tidy_and_attach]{tidy_and_attach()}}
\item \code{\link[=tidy_identify_variables]{tidy_identify_variables()}}
\item \code{\link[=tidy_add_contrasts]{tidy_add_contrasts()}}
\item \code{\link[=tidy_add_reference_rows]{tidy_add_reference_rows()}}
\item \code{\link[=tidy_add_estimate_to_reference_rows]{tidy_add_estimate_to_reference_rows()}}
\item \code{\link[=tidy_add_variable_labels]{tidy_add_variable_labels()}}
\item \code{\link[=tidy_add_term_labels]{tidy_add_term_labels()}}
\item \code{\link[=tidy_add_header_rows]{tidy_add_header_rows()}}
\item \code{\link[=tidy_remove_intercept]{tidy_remove_intercept()}}
\item \code{\link[=tidy_detach_model]{tidy_detach_model()}}
}
}
\examples{
ex1 <- lm(Sepal.Length ~ Sepal.Width + Species, data = iris) \%>\%
  tidy_plus_plus()
ex1

df <- Titanic \%>\%
  dplyr::as_tibble() \%>\%
  dplyr::mutate(
    Survived = factor(Survived, c("No", "Yes"))
  ) \%>\%
  labelled::set_variable_labels(
    Class = "Passenger's class",
    Sex = "Gender"
  )

ex2 <- glm(
  Survived ~ Class + Age * Sex,
  data = df, weights = df$n,
  family = binomial
) \%>\%
  tidy_plus_plus(exponentiate = TRUE)
ex2

if (requireNamespace("gtsummary")) {
  ex3 <- glm(
    response ~ poly(age, 3) + stage + grade * trt,
    na.omit(gtsummary::trial),
    family = binomial,
    contrasts = list(
      stage = contr.treatment(4, base = 3),
      grade = contr.sum
    )
  ) \%>\%
    tidy_plus_plus(
      exponentiate = TRUE,
      variable_labels = c(age = "Age (in years)"),
      add_header_rows = TRUE,
      show_single_row = "trt",
      term_labels = c("poly(age, 3)3" = "Cubic age"),
      keep_model = TRUE
    )
  ex3
}
}
\seealso{
Other tidy_helpers: 
\code{\link{tidy_add_contrasts}()},
\code{\link{tidy_add_estimate_to_reference_rows}()},
\code{\link{tidy_add_header_rows}()},
\code{\link{tidy_add_reference_rows}()},
\code{\link{tidy_add_term_labels}()},
\code{\link{tidy_add_variable_labels}()},
\code{\link{tidy_attach_model}()},
\code{\link{tidy_identify_variables}()},
\code{\link{tidy_remove_intercept}()}
}
\concept{tidy_helpers}
