% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/n-obs.R
\name{n_obs}
\alias{n_obs}
\title{Return the number of observations}
\usage{
n_obs(x, names = TRUE)
}
\arguments{
\item{x}{vector or data.frame}

\item{names}{logical; If TRUE the result is a named vector named "n_obs", else
it is just the number of observations.}
}
\value{
number of observations
}
\description{
Returns the number of observations of a vector or data.frame. It uses
\code{vctrs::vec_size()} under the hood.
}
\note{
You cannot use \code{n_obs} with \code{features} counting the key variable like
so - \code{features(heights, country, n_obs)}. Instead, use any other variable.
}
\examples{
n_obs(iris)
n_obs(1:10)
add_n_obs(heights)
heights \%>\%
  features(height_cm, n_obs) # can be any variable except id, the key.
}
