% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brokenstick-class.R
\name{brokenstick-class}
\alias{brokenstick-class}
\title{Class \code{brokenstick}}
\description{
The main fitting function \code{\link[=brokenstick]{brokenstick()}} returns an object of class
\code{brokenstick}. This object collects the fitted broken stick model.
}
\details{
The package exports S3 methods for the \code{brokenstick} class for the following
generic functions: \code{\link[=fitted]{fitted()}}, \code{\link[=model.frame]{model.frame()}}, \code{\link[=model.matrix]{model.matrix()}}, \code{\link[=plot]{plot()}},
\code{\link[=predict]{predict()}}, \code{\link[=print]{print()}}, \code{\link[=residuals]{residuals()}}.

The package documents methods \code{\link[=fitted.brokenstick]{fitted.brokenstick()}}, \code{\link[=plot.brokenstick]{plot.brokenstick()}},
\code{\link[=predict.brokenstick]{predict.brokenstick()}} and \code{\link[=residuals.brokenstick]{residuals.brokenstick()}}. The package exports
two helper functions for \code{brokenstick} objects: \code{\link[=get_knots]{get_knots()}} and \code{\link[=get_r2]{get_r2()}}.

A \code{brokenstick} object is a list with the following named elements:
}
\section{Elements}{

\describe{
\item{\code{names}}{A list with elements named \code{x}, \code{y} and \code{g} providing the
variables names for the time, outcome and subject columns, respectively.}
\item{\code{knots}}{Numeric vector of with the internal knots. Use \code{\link[=get_knots]{get_knots()}}
to extract knots.}
\item{\code{boundary}}{Numeric vector of length 2 with the boundary knots. Use
\code{\link[=get_knots]{get_knots()}} to extract knots.}
\item{\code{degree}}{The \code{degree} of the B-spline. See \code{\link[splines:bs]{splines::bs()}}. Either
0 (constant model) or 1 (broken stick model).}
\item{\code{model}}{Not used.}
\item{\code{method}}{Either \code{lmer} or \code{kr}, identifying the fitting model.}
\item{\code{control}}{List of control option returned by \code{\link[=control_brokenstick]{control_brokenstick()}}.}
\item{\code{beta}}{Numeric vector with fixed effect estimates.}
\item{\code{omega}}{Numeric matrix with variance-covariance estimates of the
random effect.}
\item{\code{sigma2j}}{Numeric vector with estimates of the residual variance per
group. Only used by method \code{kr}.}
\item{\code{sigma2}}{Numeric scalar with the mean residual variance.}
\item{\code{draws}}{Numeric matrix with multiple imputations. The number of
rows is equal to the number of missing values in \code{y}. The number of columns
depends on \code{imp_skip}. Only used by \code{kr} if \code{imp_skip} is set.}
}
}

\references{
van Buuren S (2020).
Broken Stick Model for Irregular Longitudinal Data. \emph{In preparation}.
}
\author{
Stef van Buuren, 2020
}
