% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loo-helpers.R
\name{reloo}
\alias{reloo}
\title{Compute exact cross-validation for problematic observations}
\usage{
reloo(x, fit, k_threshold = 0.7, newdata = NULL, resp = NULL,
  check = TRUE, ...)
}
\arguments{
\item{x}{An \R object of class \code{loo}.}

\item{fit}{An \R object of class \code{brmsfit}.}

\item{k_threshold}{The threshold at which pareto \eqn{k} 
estimates are treated as problematic. Defaults to \code{0.7}. 
See \code{\link[loo:pareto_k_ids]{pareto_k_ids}}
for more details.}

\item{newdata}{An optional data.frame for which to evaluate predictions. If
\code{NULL} (default), the original data of the model is used.}

\item{resp}{Optional names of response variables. If specified, predictions
are performed only for the specified response variables.}

\item{check}{Logical; If \code{TRUE} (the default), some checks
check are performed if the \code{loo} object was generated
from the \code{brmsfit} object passed to argument \code{fit}.}

\item{...}{Further arguments passed to 
\code{\link{update.brmsfit}} and \code{\link{log_lik.brmsfit}}.}
}
\value{
An object of the class \code{loo}.
}
\description{
Compute exact cross-validation for problematic observations for which
approximate leave-one-out cross-validation may return incorrect results.
Models for problematic observations can be run in parallel using the
\pkg{future} package.
}
\details{
Warnings about Pareto \eqn{k} estimates indicate observations
for which the approximation to LOO is problematic (this is described in
detail in Vehtari, Gelman, and Gabry (2017) and the 
\pkg{\link[loo:loo-package]{loo}} package documentation).
If there are \eqn{J} observations with \eqn{k} estimates above
\code{k_threshold}, then \code{reloo} will refit the original model 
\eqn{J} times, each time leaving out one of the \eqn{J} 
problematic observations. The pointwise contributions of these observations
to the total ELPD are then computed directly and substituted for the
previous estimates from these \eqn{J} observations that are stored in the
original \code{loo} object.
}
\examples{
\dontrun{
fit1 <- brm(count ~ zAge + zBase * Trt + (1|patient),
           data = epilepsy, family = poisson())
# throws warning about some pareto k estimates being too high
(loo1 <- loo(fit1))
(reloo1 <- reloo(loo1, fit1, chains = 1))
}

}
\seealso{
\code{\link{loo}}, \code{\link{kfold}}
}
